// Event listeners for backlink and traffic check buttons
document.getElementById('backlink-exact-btn').addEventListener('click', function () {
  checkUrl('backlink', 'exact');
});

document.getElementById('backlink-subdomain-btn').addEventListener('click', function () {
  checkUrl('backlink', 'subdomain');
});

document.getElementById('traffic-exact-btn').addEventListener('click', function () {
  checkUrl('traffic', 'exact');
});

document.getElementById('traffic-subdomain-btn').addEventListener('click', function () {
  checkUrl('traffic', 'subdomain');
});

// Event listener for WHOIS button
document.getElementById('whois-btn').addEventListener('click', function () {
  checkWhois();
});

// Function to check URL based on button click (backlink or traffic)
function checkUrl(type, mode) {
  chrome.tabs.query({ active: true, currentWindow: true }, function (tabs) {
    let url = new URL(tabs[0].url);
    let inputUrl = encodeURIComponent(url.href);
    let subdomainUrl = encodeURIComponent(`${url.protocol}//${url.hostname}/`);

    let ahrefsUrl = '';
    
    if (type === 'backlink') {
      if (mode === 'exact') {
        ahrefsUrl = `https://ahrefs.com/backlink-checker/?input=${inputUrl}&mode=exact`;
      } else if (mode === 'subdomain') {
        ahrefsUrl = `https://ahrefs.com/backlink-checker/?input=${subdomainUrl}&mode=subdomains`;
      }
    } else if (type === 'traffic') {
      if (mode === 'exact') {
        ahrefsUrl = `https://ahrefs.com/traffic-checker/?input=${inputUrl}&mode=exact`;
      } else if (mode === 'subdomain') {
        ahrefsUrl = `https://ahrefs.com/traffic-checker/?input=${subdomainUrl}&mode=subdomains`;
      }
    }

    // Open in new tab
    chrome.tabs.create({ url: ahrefsUrl });
  });
}

// Function to open WHOIS lookup for the current domain
function checkWhois() {
  chrome.tabs.query({ active: true, currentWindow: true }, function (tabs) {
    let url = new URL(tabs[0].url);
    let domain = url.hostname;

    // Construct WHOIS lookup URL for the current domain
    let whoisUrl = `https://whois.domaintools.com/${domain}`;

    // Open in new tab
    chrome.tabs.create({ url: whoisUrl });
  });
}
